--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Buildings
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local changed = false

local function DoOne(b)
	if not b.owned then
		local label = GetString(b.port.name).." - "..GetString(b.name)
		label = "+ "..label
		SetLabel(b.name, label)

		b:MarkOwned()
		gSim:QueueMessage("Debug: "..tostring(b.name))
	end
end

local function DoFactories()
	for b in LFactory:AllFactories() do DoOne(b) end
end

local function DoShops()
	for b in LShop:AllShops() do DoOne(b) end
end

local function DoLabs()
	for b in LLaboratory:AllLabs() do DoOne(b) end
end

local function CloseMenu()
	gSim:FlushMessages()
	CloseWindow()
end

-------------------------------------------------------------------------------

local menu = {}
local x=0
local y=0

local function FillMenu(iterator)
	for building in iterator do
		local b = building

		local label = GetString(b.port.name).." - "..GetString(b.name)
		if b.owned then label = "#+ "..label
		else label = "#- "..label
		end
		
		table.insert(menu, DevMenuItem { x=0,y=y, w=100, label=label, name=b.name, command=function() DoOne(b) gSim:FlushMessages() end })
		y = y + bsgFontHeight(devfont) + 2
	end
end

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-CLOSE-", command=CloseMenu })
y = y + bsgFontHeight(devfont) + 2

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-FACTORIES-", command=function() DoFactories() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2

FillMenu(LFactory:AllFactories())
	
table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-SHOPS-", command=function() DoShops() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2

FillMenu(LShop:AllShops())

table.insert(menu, DevMenuItem { x=0,y=y, w=100, label="#-LABORATORIES-", command=function() DoLabs() CloseMenu() end })
y = y + bsgFontHeight(devfont) + 2

FillMenu(LLaboratory:AllLabs())

-------------------------------------------------------------------------------

x = gDialogTable.x or 0
y = gDialogTable.y or 0

MakeDialog
{
	Rectangle
	{
		x=x,y=y, color=devBackgroundColor, alpha=devAlpha, inset=3,
		Group(menu),
	}
}
